"use client";

import { useDispatch } from "react-redux";
import { setUser } from "@/app/lib/features/user/UserSlice";
import { useEffect } from "react";
import { useRouter, useSearchParams } from "next/navigation";
import { setCookie } from "cookies-next";
import axios from "axios";
import LoadingSpinner from "@/app/LoadingSpinner";
import getDeviceId from "@/app/hooks/useVisitorId";

export default function ChatPortPage({ params }) {
  const { chatPort } = params;

  const dispatch = useDispatch();
  const router = useRouter();


  useEffect(() => {
 
    // Check if the user is on a mobile device
    const isMobile = /Mobi|Android|iPhone|iPad|iPod|Windows Phone/i.test(navigator.userAgent);

    if (isMobile) {
      // If the user is on mobile, redirect to the login page
      router.push("/login");
      return; // Stop further execution
    }
    if (!chatPort || !Array.isArray(chatPort)) {
      router.push("/login")
      return;
    }
  
    // Join and decode the segments of chatPort
    const encodedQueryString = chatPort.join("&");
    const queryString = decodeURIComponent(encodedQueryString);
  
  
    // Parse parameters using URLSearchParams
    const urlParams = new URLSearchParams(queryString);
  
    const t = urlParams.get("t");
    const u = urlParams.get("u");
    const e = urlParams.get("e");
    const i = urlParams.get("i");
    const r = urlParams.get("r");
    const w = urlParams.get("w");
    // Get parameters from URL
    

      // Ensure parameters are valid
      if ((!t || !u || !e || !i) && !w) {
        // Route to login only if both conditions fail
                router.push("/login");
        return;
      }
  
      // router.replace("/chat-port/w=wait");

    // Immediately clean the URL by removing query parameters

    // API call after URL cleanup
    const fetchChatPortal = async () => {
      try {
        const d  = await getDeviceId();
        const response = await axios.post(
          `${process.env.NEXT_PUBLIC_API_URL}/api/chatportal`, // Use POST for sending body
          { t, u, e, i, r,d }, // Parameters as JSON in the request body
          {
            headers: {
              "Content-Type": "application/json",
            },
          }
        );

        const data = response.data;

        // Save token in cookies
        setCookie("token", data.token);
        setCookie('refreshToken', data.refreshToken)
        // Update Redux store
        dispatch(setUser(data.user));

        // Route user based on role
        if (data.role === 1) router.push("/company-management");
        else if (data.role === 2) router.push("/brands");
        else router.push("/chat");
      } catch (err) {
        router.push("/login");
      }
    };

    fetchChatPortal();
  }, []);

  return (
    <>
      <LoadingSpinner />
    </>
  );
}
